"use client";

import { ThemeProvider } from "next-themes";
import { SessionProvider } from "next-auth/react";
import { LocalizationProvider } from "@/components/providers/LocalizationProvider";
import { BrandingProvider } from "@/components/providers/BrandingProvider";

interface ProvidersProps {
  children: React.ReactNode;
}

export function Providers({ children }: ProvidersProps) {
  return (
    <SessionProvider>
      <ThemeProvider
        attribute="class"
        defaultTheme="system"
        enableSystem
        disableTransitionOnChange
      >
        <BrandingProvider>
          <LocalizationProvider>{children}</LocalizationProvider>
        </BrandingProvider>
      </ThemeProvider>
    </SessionProvider>
  );
}
