"use client";

import { User } from "lucide-react";
import { SettingsLayout } from "@/components/settings/settings-layout";
import { ProfileSettings } from "@/components/settings/profile-settings";

export default function ProfileSettingsPage() {
  return (
    <SettingsLayout
      title="Profile Settings"
      description="Manage your personal information and account details"
      icon={User}
      section="profile"
      showRefresh={true}
    >
      {({ userProfile, onUpdate, onAlert }) => (
        <ProfileSettings
          user={userProfile}
          onUpdate={onUpdate}
          onAlert={onAlert}
        />
      )}
    </SettingsLayout>
  );
}
