"use client";

import { Palette } from "lucide-react";
import { SettingsLayout } from "@/components/settings/settings-layout";
import { DisplaySettings } from "@/components/settings/display-settings";

export default function DisplaySettingsPage() {
  return (
    <SettingsLayout
      title="Display & Appearance"
      description="Customize the look and feel of your interface"
      icon={Palette}
      section="display"
    >
      {({ userSettings, onUpdate, onAlert }) => (
        <DisplaySettings
          settings={userSettings?.display}
          onUpdate={onUpdate}
          onAlert={onAlert}
        />
      )}
    </SettingsLayout>
  );
}
