"use client";

import { useRouter } from "next/navigation";
import { Button } from "@/components/ui/button";
import { ArrowLeft } from "lucide-react";
import SimplifiedLeaseCreation from "@/components/lease/SimplifiedLeaseCreation";

export default function NewLeasePage() {
  const router = useRouter();

  return (
    <div className="space-y-6">
      {/* Header */}
      <div className="flex items-center justify-between">
        <div>
          <h1 className="text-3xl font-bold tracking-tight">
            Create New Lease
          </h1>
          <p className="text-muted-foreground">
            Create a new lease agreement with automatic invoice generation
          </p>
        </div>
        <Button
          variant="outline"
          size="sm"
          onClick={() => router.back()}
          className="flex items-center gap-2"
        >
          <ArrowLeft className="h-4 w-4" />
          Back to Leases
        </Button>
      </div>

      {/* Simplified Lease Creation Form */}
      <SimplifiedLeaseCreation />
    </div>
  );
}
